/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.powerbuilder.jdbc;

import com.sybase.powerbuilder.jdbc.PbjdbcCommand;
import com.sybase.powerbuilder.jdbc.PbjdbcError;
import com.sybase.powerbuilder.jdbc.PbjdbcExportedKeyListThread;
import com.sybase.powerbuilder.jdbc.PbjdbcImportedKeyListThread;
import com.sybase.powerbuilder.jdbc.PbjdbcRSExportedKeyList;
import com.sybase.powerbuilder.jdbc.PbjdbcRSImportedKeyList;
import com.sybase.powerbuilder.jdbc.PbjdbcRowSet;
import com.sybase.powerbuilder.jdbc.PbjdbcSharing;
import com.sybase.powerbuilder.jdbc.PbjdbcTrace;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class PbjdbcSessionBase {
    protected String m_ShareID = null;
    protected Properties m_Properties;
    protected String m_URL;
    protected String m_User;
    protected String m_Password;
    protected Connection m_Connection;
    protected DatabaseMetaData m_DBMetaData;
    protected PbjdbcError m_Error;
    private boolean m_bQualifier;
    private Statement m_Statement = null;

    public static boolean SetLoginTimeOut(int n) {
        DriverManager.setLoginTimeout(n);
        return true;
    }

    public Connection GetConnection() {
        return this.m_Connection;
    }

    public int CloseStatement() {
        if (this.m_Statement != null) {
            try {
                this.m_Statement.close();
            }
            catch (SQLException sQLException) {
                this.m_Error = new PbjdbcError(sQLException);
                this.m_Statement = null;
                return -1;
            }
            this.m_Statement = null;
        }
        return 0;
    }

    public int CreateSession(String string) {
        this.m_Error = null;
        this.m_URL = null;
        this.m_User = null;
        this.m_Password = null;
        this.m_Properties = null;
        this.m_ShareID = string;
        Object object = PbjdbcSharing.getSharingObject(string);
        if (object == null || !(object instanceof Connection)) {
            this.m_Error = new PbjdbcError(2, "Failed to get external connection object.");
            return -1;
        }
        this.m_Connection = (Connection)object;
        try {
            this.m_DBMetaData = this.m_Connection.getMetaData();
            this.m_bQualifier = this.m_DBMetaData.getMaxSchemaNameLength() != 0;
            return 0;
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::CreateSession SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
    }

    public int GetJavaCnnObjKey() {
        String string = PbjdbcSharing.setSharingObject(this.m_Connection);
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    public int CreateSession(String string, String string2, String string3) {
        this.m_URL = string2;
        try {
            this.m_Error = null;
            Class.forName(string);
            this.m_Connection = DriverManager.getConnection(string2);
            if (string3 != null && string3 != "") {
                this.m_Connection.setCatalog(string3);
            }
            this.m_DBMetaData = this.m_Connection.getMetaData();
            this.m_bQualifier = this.m_DBMetaData.getMaxSchemaNameLength() != 0;
            return 0;
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::CreateSession SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        catch (ClassNotFoundException classNotFoundException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::CreateSession ClassNotFoundException thrown for " + string);
            this.m_Error = new PbjdbcError(1, "Could not load class " + string);
            return -1;
        }
    }

    public int CreateSession(String string, String string2, String string3, String string4, String string5) {
        this.m_URL = string2;
        this.m_User = string3;
        this.m_Password = string4;
        try {
            this.m_Error = null;
            Class.forName(string);
            this.m_Connection = DriverManager.getConnection(string2, string3, string4);
            if (string5 != null && string5 != "") {
                this.m_Connection.setCatalog(string5);
            }
            this.m_DBMetaData = this.m_Connection.getMetaData();
            this.m_bQualifier = this.m_DBMetaData.getMaxSchemaNameLength() != 0;
            return 0;
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::CreateSession SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        catch (ClassNotFoundException classNotFoundException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::CreateSession ClassNotFoundException thrown for " + string);
            this.m_Error = new PbjdbcError(1, "Could not load class " + string);
            return -1;
        }
    }

    public int CreateSession(String string, String string2, String string3, String string4) {
        this.m_URL = string2;
        try {
            this.m_Error = null;
            Class.forName(string);
            String string5 = string3.trim();
            if (string5.length() > 0) {
                int n;
                Properties properties = new Properties();
                int n2 = 0;
                while ((n = (string5 = string5.trim()).indexOf(61, n2)) != -1) {
                    String string6 = string5.substring(n2, n).trim();
                    n2 = n + 1;
                    if ((n = string5.indexOf(59, n2)) == -1) break;
                    String string7 = string5.substring(n2, n).trim();
                    n2 = n + 1;
                    properties.put(string6, string7);
                    if (n2 > 0 && n2 < string5.length()) continue;
                }
                this.m_Connection = DriverManager.getConnection(string2, properties);
                this.m_Properties = properties;
            } else {
                this.m_Connection = DriverManager.getConnection(string2);
            }
            if (string4 != null && string4 != "") {
                this.m_Connection.setCatalog(string4);
            }
            this.m_DBMetaData = this.m_Connection.getMetaData();
            this.m_bQualifier = this.m_DBMetaData.getMaxSchemaNameLength() != 0;
            return 0;
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::CreateSession SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        catch (ClassNotFoundException classNotFoundException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::CreateSession ClassNotFoundException thrown for" + string);
            this.m_Error = new PbjdbcError(1, "Could not load class " + string);
            return -1;
        }
    }

    public int EndSession() {
        this.m_DBMetaData = null;
        if (this.m_ShareID == null) {
            try {
                this.m_Connection.close();
            }
            catch (SQLException sQLException) {
                PbjdbcTrace.TraceMessage("Java PbjdbcSession::EndSession SQLException thrown");
                PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
                PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
                PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
                return -1;
            }
        }
        this.m_Connection = null;
        return 0;
    }

    public String GetUserName() {
        this.m_Error = null;
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetUserName Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            return null;
        }
        try {
            String string = this.m_DBMetaData.getUserName();
            return string;
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetUserName SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
    }

    public PbjdbcCommand CreateCommand() {
        Statement statement;
        this.m_Error = null;
        if (this.m_Connection == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::CreateCommand Not Connected");
            this.m_Error = new PbjdbcError(2, "Not Connected.");
            return null;
        }
        try {
            statement = this.m_Connection.createStatement();
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::CreateCommand SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        PbjdbcCommand pbjdbcCommand = new PbjdbcCommand(statement);
        return pbjdbcCommand;
    }

    public PbjdbcCommand CreateCommand(String string, int n) {
        PreparedStatement preparedStatement = null;
        PbjdbcCommand pbjdbcCommand = null;
        this.m_Error = null;
        if (this.m_Connection == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::CreateCommand Not Connected");
            this.m_Error = new PbjdbcError(2, "Not Connected.");
            return null;
        }
        try {
            preparedStatement = n == 1 ? this.m_Connection.prepareStatement(string) : this.m_Connection.prepareCall(string);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::CreateCommand SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        if (preparedStatement != null) {
            pbjdbcCommand = new PbjdbcCommand(string, n, preparedStatement);
        }
        return pbjdbcCommand;
    }

    public PbjdbcError GetLastError() {
        return this.m_Error;
    }

    public PbjdbcRowSet GetDatabaseList() {
        this.m_Error = null;
        ResultSet resultSet = null;
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetDatabaseList Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            return null;
        }
        try {
            resultSet = this.m_DBMetaData.getCatalogs();
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetDatabaseList SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetTableList(String string, String string2, String string3, String[] stringArray) {
        this.m_Error = null;
        ResultSet resultSet = null;
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetTableList Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            return null;
        }
        try {
            if (string2 == null && this.m_bQualifier) {
                string2 = "%";
            }
            if (string3 == null) {
                string3 = "%";
            }
            if (stringArray == null) {
                String[] stringArray2 = new String[]{"TABLE", "VIEW", "SYSTEM TABLE", "SYSTEM VIEW", "ALIAS"};
                stringArray = stringArray2;
            }
            resultSet = this.m_DBMetaData.getTables(string, string2, string3, stringArray);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetTableList SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetASA10TableList(String string, String string2, String string3, String[] stringArray) {
        this.m_Error = null;
        ResultSet resultSet = null;
        String string4 = null;
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null) {
            string3 = "%";
        }
        if (stringArray == null) {
            string4 = "%";
        } else {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].compareToIgnoreCase("table") == 0) {
                    string4 = string4 + "''TABLE''";
                } else if (stringArray[n].compareToIgnoreCase("view") == 0) {
                    string4 = string4 + "''VIEW''";
                } else if (stringArray[n].compareToIgnoreCase("system table") == 0) {
                    string4 = string4 + "''SYSTEM TABLE''";
                }
                ++n;
            }
        }
        String string5 = "execute sp_tables '" + string3 + "', '" + string2 + "', '%', '" + string4 + "'";
        try {
            this.m_Statement = this.m_Connection.createStatement();
            if (this.m_Statement.execute(string5)) {
                resultSet = this.m_Statement.getResultSet();
            }
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetASA10TableList SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetASETableList(String string, String string2, String string3, String[] stringArray) {
        boolean bl = true;
        this.m_Error = null;
        ResultSet resultSet = null;
        String string4 = null;
        if (string2 == null && this.m_bQualifier) {
            string2 = "%";
        }
        if (string3 == null) {
            string3 = "%";
        }
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].compareToIgnoreCase("table") == 0) {
                    if (bl) {
                        string4 = " and (o.type = 'U'";
                        bl = false;
                    } else {
                        string4 = string4 + " or o.type = 'U'";
                    }
                } else if (stringArray[n].compareToIgnoreCase("view") == 0) {
                    if (bl) {
                        string4 = " and (o.type = 'V'";
                        bl = false;
                    } else {
                        string4 = string4 + " or o.type = 'V'";
                    }
                } else if (stringArray[n].compareToIgnoreCase("system table") == 0) {
                    if (bl) {
                        string4 = " and (o.type = 'S'";
                        bl = false;
                    } else {
                        string4 = string4 + " or o.type = 'S'";
                    }
                }
                ++n;
            }
            string4 = string4 == null ? " and (o.type != 'U' and o.type != 'V' and o.type != 'S')" : string4 + ")";
        }
        String string5 = "select o.name 'TABLE_NAME', user_name(o.uid) 'TABLE_SCHEM', o.type 'TABLE_TYPE'";
        string5 = string5 + " from sysobjects o";
        string5 = string5 + " where o.name like '" + string3 + "'";
        string5 = string5 + " and user_name(o.uid) like '" + string2 + "'";
        string5 = string5 + " and charindex(substring(o.type,1,1), 'SUV') != 0";
        string5 = string5 + " and  o.id not in  (select sa1.object from sysattributes sa1, sysattributes sa2  ";
        string5 = string5 + " where sa1.class=18 and sa1.char_value!= null  and sa1.object_cinfo = sa2.object_cinfo  and sa1.object_type='P'  and sa2.object_type='WF')";
        if (string4 != null) {
            string5 = string5 + string4;
        }
        try {
            this.m_Statement = this.m_Connection.createStatement();
            if (this.m_Statement.execute(string5)) {
                resultSet = this.m_Statement.getResultSet();
            }
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetASETableList SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetProxyList() {
        ResultSet resultSet = null;
        String string = "select sa1.object, object_name(sa1.object), sa1.char_value, user_name(sa2.object_info1), sa1.object_info1, sa2.text_value";
        string = string + " from sysattributes sa1, sysattributes sa2";
        string = string + " where sa1.class=18 and sa1.char_value!= null  and sa1.object_cinfo = sa2.object_cinfo";
        string = string + " and sa1.object_type='P'  and sa2.object_type='WF'";
        string = string + " order by sa1.object_cinfo, (object_name(sa1.object)) desc";
        try {
            this.m_Statement = this.m_Connection.createStatement();
            if (this.m_Statement.execute(string)) {
                resultSet = this.m_Statement.getResultSet();
            }
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetProxyList SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetWSList() {
        ResultSet resultSet = null;
        String string = "select service_id, service_name, service_type, auth_required, secure_required, url_path, User_name(user_id)'User', parameter, statement, remarks";
        string = string + " from syswebservice where service_type = 'SOAP' and statement like 'call%' order by service_id";
        try {
            this.m_Statement = this.m_Connection.createStatement();
            if (this.m_Statement.execute(string)) {
                resultSet = this.m_Statement.getResultSet();
            }
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetWSList SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetProcedureList(String string, String string2) {
        this.m_Error = null;
        ResultSet resultSet = null;
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetProcedureList Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            return null;
        }
        try {
            if (string == null && this.m_bQualifier) {
                string = "%";
            }
            if (string2 == null) {
                string2 = "%";
            }
            resultSet = this.m_DBMetaData.getProcedures(null, string, string2);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetProcedureList SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetProcedureColumns(String string, String string2) {
        this.m_Error = null;
        ResultSet resultSet = null;
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetProcedureColumns Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            return null;
        }
        try {
            if (string == null && this.m_bQualifier) {
                string = "%";
            }
            if (string2 == null) {
                string2 = "%";
            }
            resultSet = this.m_DBMetaData.getProcedureColumns(null, string, string2, "%");
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetProcedureColumns SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetProcedureColumns(String string, String string2, String string3, String string4) {
        this.m_Error = null;
        ResultSet resultSet = null;
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetProcedureColumns Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            return null;
        }
        try {
            if (string2 == null && this.m_bQualifier) {
                string2 = "%";
            }
            if (string3 == null) {
                string3 = "%";
            }
            resultSet = this.m_DBMetaData.getProcedureColumns(string, string2, string3, string4);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetProcedureColumns SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetColumnList(String string, String string2, String string3) {
        this.m_Error = null;
        ResultSet resultSet = null;
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetColumnList Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            return null;
        }
        if (string == null && this.m_bQualifier) {
            string = "%";
        }
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null) {
            string3 = "%";
        }
        try {
            resultSet = this.m_DBMetaData.getColumns(null, string, string2, string3);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetColumnList SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetASA10IndexList(String string, String string2) {
        this.m_Error = null;
        ResultSet resultSet = null;
        if (string == null) {
            string = "%";
        }
        if (string2 == null) {
            string2 = "%";
        }
        String string3 = "select u.user_name as INDEX_QUALIFIER, i.index_name as INDEX_NAME, i.\"unique\" as UNIQUEKEY, ic.\"order\" as ASC_OR_DESC, ";
        string3 = string3 + " 3 as TYPE,ic.sequence+1 as ORDINAL_POSITION, c.column_name as COLUMN_NAME ";
        string3 = string3 + " from sys.sysindex i, sys.systab t, sys.sysuser u, sys.sysidxcol ic, sys.syscolumn c ";
        string3 = string3 + " where u.user_name like '" + string + "' and t.table_name like '" + string2 + "' ";
        string3 = string3 + " and u.user_id = t.creator and i.table_id = t.table_id and ic.table_id = t.table_id ";
        string3 = string3 + " and c.table_id = t.table_id and c.column_id = ic.column_id and ic.index_id = i.index_id ";
        string3 = string3 + " order by i.index_name, ic.sequence";
        try {
            this.m_Statement = this.m_Connection.createStatement();
            if (this.m_Statement.execute(string3)) {
                resultSet = this.m_Statement.getResultSet();
            }
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetASA10IndexList SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetIndexList(String string, String string2) {
        this.m_Error = null;
        ResultSet resultSet = null;
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetIndexList Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            return null;
        }
        if (string == null && this.m_bQualifier) {
            string = "%";
        }
        if (string2 == null) {
            string2 = "%";
        }
        try {
            resultSet = this.m_DBMetaData.getIndexInfo(null, string, string2, false, false);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetIndexList SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetORAUniqueIndexList(String string, String string2) {
        this.m_Error = null;
        ResultSet resultSet = null;
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetORAUniqueIndexList Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            return null;
        }
        if (string == null && this.m_bQualifier) {
            string = "%";
        }
        if (string2 == null) {
            string2 = "%";
        }
        try {
            resultSet = this.m_DBMetaData.getIndexInfo(null, string, string2, true, true);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetORAUniqueIndexList SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetPrimaryKeys(String string, String string2) {
        this.m_Error = null;
        ResultSet resultSet = null;
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetPrimaryKeys Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            return null;
        }
        if (string2 == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetPrimaryKeys Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Table Name cannot be null");
            return null;
        }
        if (string == null && this.m_bQualifier) {
            string = "%";
        }
        try {
            resultSet = this.m_DBMetaData.getPrimaryKeys(null, string, string2);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetPrimaryKeys SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return null;
        }
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetImportedKeys(String string, String string2) {
        DatabaseMetaData databaseMetaData;
        this.m_Error = null;
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetImportedKeys Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            return null;
        }
        if (string2 == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetImportedKeys Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Table Name cannot be null");
            return null;
        }
        if (string == null && this.m_bQualifier) {
            string = "%";
        }
        Connection connection = null;
        try {
            if (this.m_User != null && this.m_Password != null) {
                connection = DriverManager.getConnection(this.m_URL, this.m_User, this.m_Password);
            } else if (this.m_Properties != null) {
                connection = DriverManager.getConnection(this.m_URL, this.m_Properties);
            } else if (this.m_URL != null) {
                connection = DriverManager.getConnection(this.m_URL);
            }
            if (connection == null) {
                return null;
            }
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetImportedKeys SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            return null;
        }
        PbjdbcRSImportedKeyList pbjdbcRSImportedKeyList = new PbjdbcRSImportedKeyList();
        PbjdbcImportedKeyListThread pbjdbcImportedKeyListThread = new PbjdbcImportedKeyListThread(pbjdbcRSImportedKeyList, connection, databaseMetaData, string, string2);
        pbjdbcImportedKeyListThread.start();
        ResultSet resultSet = pbjdbcRSImportedKeyList.GetResultSet();
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public PbjdbcRowSet GetExportedKeys(String string, String string2) {
        DatabaseMetaData databaseMetaData;
        this.m_Error = null;
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetExportedKeys Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            return null;
        }
        if (string2 == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetExportedKeys Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Table Name cannot be null");
            return null;
        }
        if (string == null && this.m_bQualifier) {
            string = "%";
        }
        Connection connection = null;
        try {
            if (this.m_User != null && this.m_Password != null) {
                connection = DriverManager.getConnection(this.m_URL, this.m_User, this.m_Password);
            } else if (this.m_Properties != null) {
                connection = DriverManager.getConnection(this.m_URL, this.m_Properties);
            } else if (this.m_URL != null) {
                connection = DriverManager.getConnection(this.m_URL);
            }
            if (connection == null) {
                return null;
            }
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetExportedKeys SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            return null;
        }
        PbjdbcRSExportedKeyList pbjdbcRSExportedKeyList = new PbjdbcRSExportedKeyList();
        PbjdbcExportedKeyListThread pbjdbcExportedKeyListThread = new PbjdbcExportedKeyListThread(pbjdbcRSExportedKeyList, connection, databaseMetaData, string, string2);
        pbjdbcExportedKeyListThread.start();
        ResultSet resultSet = pbjdbcRSExportedKeyList.GetResultSet();
        if (resultSet != null) {
            return new PbjdbcRowSet(resultSet);
        }
        return null;
    }

    public int StartTransaction() {
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::StartTransaction Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            return -1;
        }
        if (this.m_Connection == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::StartTransaction Not Connected");
            this.m_Error = new PbjdbcError(2, "Not Connected.");
            return -1;
        }
        try {
            this.m_Error = null;
            if (!this.m_DBMetaData.supportsTransactions()) {
                this.m_Error = new PbjdbcError(1, "The database (or the database driver) does not support transactions.");
                return -1;
            }
            if (this.m_Connection.getAutoCommit()) {
                this.m_Connection.setAutoCommit(false);
            }
            return 0;
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::StartTransaction SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
    }

    public boolean CanCommit() throws NullPointerException, SQLException {
        boolean bl = false;
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::CanCommit Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            throw new NullPointerException();
        }
        if (this.m_Connection == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::Commit Not Connected");
            this.m_Error = new PbjdbcError(2, "Not Connected.");
            throw new NullPointerException();
        }
        try {
            bl = this.m_DBMetaData.supportsTransactions() && !this.m_Connection.getAutoCommit();
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::CanCommit SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return bl;
    }

    public int Commit() {
        if (this.m_Connection == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::Commit Not Connected");
            this.m_Error = new PbjdbcError(2, "Not Connected.");
            return -1;
        }
        try {
            this.m_Error = null;
            if (!this.CanCommit()) {
                PbjdbcTrace.TraceMessage("Java PbjdbcSession::Commit Commit impossible--not supported or AutoCommit turned on");
                this.m_Error = new PbjdbcError(1, "Commit impossible--not supported or AutoCommit turned on.");
                return -1;
            }
            this.m_Connection.commit();
            this.m_Connection.setAutoCommit(true);
            return 0;
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::Commit SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    public int Rollback() {
        if (this.m_DBMetaData == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::Rollback Database Metadata is not available");
            this.m_Error = new PbjdbcError(2, "Database Metadata is not available");
            return -1;
        }
        if (this.m_Connection == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::Rollback Not Connected");
            this.m_Error = new PbjdbcError(2, "Not Connected.");
            return -1;
        }
        try {
            this.m_Error = null;
            if (!this.m_DBMetaData.supportsTransactions()) {
                PbjdbcTrace.TraceMessage("Java PbjdbcSession::Rollback Transactions not supported");
                this.m_Error = new PbjdbcError(1, "The database (or the database driver) does not support transactions.");
                return -1;
            }
            if (!this.m_Connection.getAutoCommit()) {
                this.m_Connection.rollback();
            }
            return 0;
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::Rollback SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
    }

    public DatabaseMetaData GetMetaData() {
        return this.m_DBMetaData;
    }

    public int SetLogStream(String string) {
        if (string != null && string.length() > 0) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                DriverManager.setLogWriter(printWriter);
            }
            catch (IOException iOException) {
                PbjdbcTrace.TraceMessage("Java PbjdbcSession::SetLogStream IOException thrown for " + string);
                this.m_Error = new PbjdbcError(1, "IOException thrown for " + string);
                return -1;
            }
        } else {
            DriverManager.setLogWriter(null);
        }
        return 0;
    }

    public int SetTransactionIsolation(String string) {
        if (this.m_Connection == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::SetTransactionIsolation Not Connected");
            this.m_Error = new PbjdbcError(2, "Not Connected.");
            return -1;
        }
        boolean bl = false;
        int n = 0;
        if (string != null) {
            if (string.equalsIgnoreCase("RU")) {
                bl = true;
                n = 1;
            } else if (string.equalsIgnoreCase("RC")) {
                bl = true;
                n = 2;
            } else if (string.equalsIgnoreCase("RR")) {
                bl = true;
                n = 4;
            } else if (string.equalsIgnoreCase("TS")) {
                bl = true;
                n = 8;
            } else if (string.equalsIgnoreCase("TN")) {
                bl = true;
                n = 0;
            }
        }
        if (bl) {
            try {
                this.m_Connection.setTransactionIsolation(n);
            }
            catch (SQLException sQLException) {
                PbjdbcTrace.TraceMessage("Java PbjdbcSession::SetTransactionIsolation SQLException thrown");
                PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
                PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
                PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
                this.m_Error = new PbjdbcError(sQLException);
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public int SetCatalog(String string) {
        try {
            this.m_Connection.setCatalog(string);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::SetCatalog SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public String GetCatalog() {
        String string = null;
        try {
            string = this.m_Connection.getCatalog();
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcSession::GetCatalog SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
        }
        if (string == null) {
            string = new String("");
        }
        return string;
    }
}

